/***************************************************************************
 *              SMA Solar Technology AG, 34266 Niestetal, Germany
 ***************************************************************************
 *
 *  Copyright (c) 2008-2014
 *  SMA Solar Technology AG
 *  All rights reserved.
 *  This design is confidential and proprietary of SMA Solar Technology AG.
 *
 ***************************************************************************/

#ifndef CONSOLE_H_
#define CONSOLE_H_

#include <iostream>

/*
 * Console color escapes (foreground)
 */

#define TRED(ARG)     "\033[31m" << ARG << "\033[0m"
#define TGREEN(ARG)   "\033[32m" << ARG << "\033[0m"
#define TYELLOW(ARG)  "\033[33m" << ARG << "\033[0m"
#define TBLUE(ARG)    "\033[34m" << ARG << "\033[0m"
#define TMAGENTA(ARG) "\033[35m" << ARG << "\033[0m"
#define TCYAN(ARG)    "\033[36m" << ARG << "\033[0m"

/*
 * Console color escapes (background)
 */

#define T_BG_RED(ARG)    "\033[41m" << ARG << "\033[0m"
#define T_BG_GREEN(ARG)  "\033[42m" << ARG << "\033[0m"
#define T_BG_YELLOW(ARG) "\033[43m" << ARG << "\033[0m"
#define T_BG_BLUE(ARG)   "\033[44m" << ARG << "\033[0m"

/*!
 * @brief Waits for an ENTER keypress
 */
static inline void waitNewline()
{
   while (std::cin.get() != '\n')
      ;
}

#endif
