#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
 
struct sockaddr_in    localSock;
struct ip_mreq        group;
int                   sd;
int                   datalen;
char                  databuf[1024];

typedef struct 
	{ unsigned char sma_header[4];
          unsigned char tag0len[2];
          unsigned char tag0id[2];
          unsigned char tag0data[4];
          unsigned char datlen[2];
          unsigned char tag[2];
	  unsigned char proto[2];
          unsigned char susy[2];
          unsigned char serno[4];
          unsigned char ticker[4];
          unsigned char channels[1500];
	} EMETER_DATA;

typedef struct
	{ 
        unsigned char channel;
	unsigned char idx;
	unsigned char typ;
	unsigned char tariff;
	unsigned char value[8];
	} OBIS_TAG;


#define GETW(_a) ((((unsigned int)(_a)[0]) << 8)+ ((_a)[1]))

#define GETDW(_a) (\
                   ( GETW((unsigned char *)(_a)) << 16)\
                  + (GETW((unsigned char *)(_a)+2) ) )


EMETER_DATA emeter_data;

static void dump(unsigned char * p, int num)
{
	int i   = num; //sizeof(emeter_data);
	int lin = 0;

	while(i >= 8)
	{
		for(lin=0; lin<8; lin++)
			printf(" %02X", (unsigned int)*p++);
		printf("\r\n");
		i-=8;
	}		
	for(lin=0; lin<i; lin++)
		printf(" %02X", (unsigned int)*p++);
	printf("\r\n");
}	

#define CHNTYP_CNTR 8
#define CHNTYP_MEAS 4
#define CHNIDX_PWR  1

static OBIS_TAG notfound={0xFF, 0xFF, 0xFF, 0xFF, 0,0,0,0,0,0,0,0}; // empty tag for notfound entries

static unsigned char * find_tag(unsigned char * emdat, int len, unsigned char typ, unsigned char idx)
{
OBIS_TAG *dat;

	while(len > 0)
	{
		dat = (OBIS_TAG*) emdat;
		if((dat->typ == typ) && (dat->idx == idx)) // match?
			return dat->value;

		if(dat->typ == CHNTYP_CNTR)	// counters are 8 Bytes long
			emdat += 12;
		else
			emdat += 8;
	
	}

	return (unsigned char*)&notfound;	// no match
}

static double kW, kWh;
static void handle_emeter(EMETER_DATA *emeter_data)
{
	unsigned long cntr;
	unsigned int  pwr;

	pwr  = GETDW(find_tag( emeter_data->channels, GETW(emeter_data->datlen), CHNTYP_MEAS, CHNIDX_PWR));
	cntr =           GETDW(4+find_tag( emeter_data->channels, GETW(emeter_data->datlen), CHNTYP_CNTR, CHNIDX_PWR)) 
             + 65536UL * GETDW(  find_tag( emeter_data->channels, GETW(emeter_data->datlen), CHNTYP_CNTR, CHNIDX_PWR));

	kW  = (double)pwr / 10000;
	kWh = (double)cntr / 3600000.0;
}


int main (int argc, char *argv[])
{
    Display                 *display;
    Visual                  *visual;
    int                     depth;
    int                     text_x;
    int                     text_y;
    XSetWindowAttributes    frame_attributes;
    Window                  frame_window;
    XFontStruct             *fontinfo;
    XGCValues               gr_values;
    GC                      graphical_context;
    XEvent                  event;
    int 		    x11_fd;
    fd_set 		    in_fds;


struct timeval tv;
 
///////////// socket installation 
  /* ------------------------------------------------------------*/
  /*                                                             */
  /* Receive Multicast Datagram code example.                    */
  /*                                                             */
  /* ------------------------------------------------------------*/
 
  /*
   * Create a datagram socket on which to receive.
   */
  sd = socket(AF_INET, SOCK_DGRAM, 0);
  if (sd < 0) {
    perror("opening datagram socket");
    exit(1);
  }
 
  /*
   * Enable SO_REUSEADDR to allow multiple instances of this
   * application to receive copies of the multicast datagrams.
   */
  {
    int reuse=1;
 
    if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR,
                   (char *)&reuse, sizeof(reuse)) < 0) {
      perror("setting SO_REUSEADDR");
      close(sd);
      exit(1);
    }
  }
 
  /*
   * Bind to the proper port number with the IP address
   * specified as INADDR_ANY.
   */
  memset((char *) &localSock, 0, sizeof(localSock));
  localSock.sin_family = AF_INET;
  localSock.sin_port = htons(9522);;
  localSock.sin_addr.s_addr  = INADDR_ANY;
 
  if (bind(sd, (struct sockaddr*)&localSock, sizeof(localSock))) {
    perror("binding datagram socket");
    close(sd);
    exit(1);
  }
 
 
  /*
   * Join the multicast group on all  adresses
   * Note that this IP_ADD_MEMBERSHIP option must be
   * called for each local interface over which the multicast
   * datagrams are to be received.
   */
  group.imr_multiaddr.s_addr = inet_addr("239.12.255.254");
  group.imr_interface.s_addr = htonl(INADDR_ANY);
  if (setsockopt(sd, IPPROTO_IP, IP_ADD_MEMBERSHIP,
                 (char *)&group, sizeof(group)) < 0) {
    perror("adding multicast group");
    close(sd);
    exit(1);
  }
 


///////////// X11
    display = XOpenDisplay(NULL);
    visual = DefaultVisual(display, 0);
    depth  = DefaultDepth(display, 0);
     
    frame_attributes.background_pixel = XWhitePixel(display, 0);
    /* create the application window */
    frame_window = XCreateWindow(display, XRootWindow(display, 0),
                                 0, 0, 300, 60, 5, depth,
                                 InputOutput, visual, CWBackPixel,
                                 &frame_attributes);
    XStoreName(display, frame_window, "Energymeter");
    XSelectInput(display, frame_window, ExposureMask | StructureNotifyMask);
 
    fontinfo             = XLoadQueryFont(display, "10x20");
    gr_values.font       = fontinfo->fid;
    gr_values.foreground = XWhitePixel(display, 0);
    gr_values.background = XWhitePixel(display, 0);
    graphical_context    = XCreateGC(display, frame_window, GCFont+GCForeground, &gr_values);
    XMapWindow(display, frame_window);
 
  // This returns the FD of the X11 display (or something like that)
    x11_fd = ConnectionNumber(display);

    while ( 1 ) 
    {
	static unsigned char string[1000];
        XWindowAttributes window_attributes;
        int font_direction, font_ascent, font_descent;
            XCharStruct text_structure;

	if (read(sd, &emeter_data,  sizeof(emeter_data)) < 0)
	    perror("reading emeter message");
	else
	    handle_emeter(&emeter_data);

	snprintf(string,999,"%1.3fkW, %1.3fkWh (%1.0fct/h)", kW, kWh, kW*27);
	string[999] = 0;

           // Handle XEvents and flush the input 
        while(XPending(display))
        {
	     XNextEvent(display, (XEvent *)&event);
             switch ( event.type ) 
	     {
             case Expose:
                {
                break;
                }
            default:
                break;
            }
       }
       XTextExtents(fontinfo, string, strlen(string),
                    &font_direction, &font_ascent, &font_descent,
                    &text_structure);
       XGetWindowAttributes(display, frame_window, &window_attributes);
       text_x = (window_attributes.width - text_structure.width)/2;
       text_y = (window_attributes.height -
                (text_structure.ascent+text_structure.descent))/2;
       XDrawImageString(display, frame_window, graphical_context,
                   text_x, text_y, string, strlen(string));
    }
    return(0);
}


