#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
 
struct sockaddr_in    localSock;
struct ip_mreq        group;
int                   sd;
int                   datalen;
char                  databuf[1024];

typedef struct 
	{ unsigned char sma_header[12];
          unsigned char datlen[2];
          unsigned char skip[4];
          unsigned char susy[2];
          unsigned char serno[4];
          unsigned char ticker[4];
          unsigned char channels[1500];
	} EMETER_DATA;

typedef struct
	{ 
    unsigned char channel;
	unsigned char idx;
	unsigned char typ;
	unsigned char tariff;
	unsigned char value[8];
	} OBIS_TAG;


#define GETW(_a) ((((unsigned int)(_a)[0]) << 8)+ ((_a)[1]))

#define GETDW(_a) (\
                   ( GETW((unsigned char *)(_a)) << 16)\
                  + (GETW((unsigned char *)(_a)+2) ) )


static EMETER_DATA emeter_data;
static int ShowSerial = 0,
	   ShowTimestamp = 0,
	   ShowInfos = 0,
	   ShowUnits = 0;


#define CHNTYP_CNTR 8
#define CHNTYP_MEAS 4
#define CHNIDX_PWR  1

static OBIS_TAG notfound={0xFF, 0xFF, 0xFF, 0xFF, 0,0,0,0,0,0,0,0}; // empty tag for notfound entries

static unsigned char * find_tag(unsigned char * emdat, int len, unsigned char typ, unsigned char idx)
{
OBIS_TAG *dat;

	while(len > 0)
	{
		dat = (OBIS_TAG*) emdat;
		if((dat->typ == typ) && (dat->idx == idx)) // match?
			return dat->value;

		if(dat->typ == CHNTYP_CNTR)	// counters are 8 Bytes long
		{
			emdat += 12;
			len   -= 12;
		}
		else
		{
			emdat += 8;
			len   -= 8;
		}
	
	}
	return (unsigned char*)&notfound.channel;// no match
}


static double handle_emeter(EMETER_DATA *emeter_data, int typ, int idx)
{
	unsigned long rawvalue;
	double        value;
	int           datlen = GETW(emeter_data->datlen);

	if(typ == CHNTYP_CNTR)
	{
	    rawvalue =           GETDW(4 + find_tag(emeter_data->channels, datlen, typ, idx)) 
                     + 65536UL * GETDW(    find_tag(emeter_data->channels, datlen, typ, idx));
	   switch(idx)
	   {	// Leistung
	   case  1: case  2: case  3: case  4: case  9: case 10:
           case 21: case 22: case 23: case 24: case 29: case 30:
           case 41: case 42: case 43: case 44: case 49: case 50:
           case 61: case 62: case 63: case 64: case 69: case 70:
					value = rawvalue / 3600000.0;	// in 1 Ws -> kWh
					if(ShowUnits) printf("kWh:");
	   break;
	   default:			value = -1;
					if(ShowUnits) printf("unknown: ");
	   }
	}
	else
	{
	   rawvalue = GETDW(find_tag( emeter_data->channels, datlen, typ, idx)); 
	   switch(idx)
	   {
	   case  1: case  2: case  3: case  4: case  9: case 10:
           case 21: case 22: case 23: case 24: case 29: case 30:
           case 41: case 42: case 43: case 44: case 49: case 50:
           case 61: case 62: case 63: case 64: case 69: case 70:
					value = rawvalue * 0.1;	// in 0.1 W
					if(ShowUnits) printf("W: ");
	   break;
	   case 31: case 51: case 71: 
					value = rawvalue / 1000.0; // mA,mV -> A,V
					if(ShowUnits) printf("A: ");
	   break;
	   case 32: case 52: case 72:
					value = rawvalue / 1000.0; // mA,mV -> A,V
					printf("V: ");
	   break;
	   break;
           case 13:                     value = rawvalue *0.001;  // cosphi
	   default:			value = -1;
  					if(ShowUnits) printf("unknown: ");
	   }
	}
	

	printf("%f",value);  // value
	return value;
}

 
int main (int argc, char *argv[])
{
	int typ = 4;
	int idx = 1;
	int cnt = 1;

/* CHECK ARGUMENTS */

  if(1 >= argc)
  {
     printf("usage: em [-u] <idx> (<typ>)""\r\n"
            "   eg. em 1 4  to retrieve current power""\r\n"
            "       em 1 8  to retrieve power counter""\r\n"
            "    -----------------""\r\n"
            "       em 1  defaults to em 1 4""\r\n"
            "   use em [-u] <idx><typ>...<idx><typ> to retrieve list of values""\r\n"  
           );
     exit(1);
  }
   for(idx=1; idx < argc; idx++)
   {
	if(*(argv[idx])=='-')
	{
		switch(*(1+argv[idx]))
		{
		case 's':
		ShowSerial = 1;
		break;
		case 't':
		ShowTimestamp = 1;
		break;
		case 'v':
		ShowInfos = 1;
		break;
		case 'u':
		ShowUnits = 1;
		break;
		case '?':
			printf("Index  Description     ""\r\n"
			       "-------------------------------""\r\n"
                               " 1   pos. Wirkleistung""\r\n"
                               " 2   neg. Wirkleistung""\r\n"
                               " 3   pos. Blindleistung""\r\n"
                               " 4   neg. Blindleistung""\r\n"
                               " 9   pos. Scheinleistung""\r\n"
                               "10   neg. Scheinleistung""\r\n"
                               "21   pos. Wirkleistung  L1""\r\n"
                               "22   neg. Wirkleistung  L1""\r\n"
                               "23   pos. Blindleistung L1""\r\n"
                               "24   neg. Blindleistung L1""\r\n"
                               "29   pos. Scheinleistung L1""\r\n"
                               "30   neg. Scheinleistung L1""\r\n"
                               "31   Strom L1(A) ""\r\n"
                               "32   Spannung L1(V)""\r\n"
                               "41   pos. Wirkleistung  L2""\r\n"
                               "42   neg. Wirkleistung  L2""\r\n"
                               "43   pos. Blindleistung L2""\r\n"
                               "44   neg. Blindleistung L2""\r\n"
                               "49   pos. Scheinleistung L2""\r\n"
                               "50   neg. Scheinleistung L2""\r\n"
                               "51   Strom L2(A) ""\r\n"
                               "52   Spannung L2(V)""\r\n"
                               "61   pos. Wirkleistung  L3""\r\n"
                               "62   neg. Wirkleistung  L3""\r\n"
                               "63   pos. Blindleistung L3""\r\n"
                               "64   neg. Blindleistung L3""\r\n"
                               "69   pos. Scheinleistung L3""\r\n"
                               "70   neg. Scheinleistung L3""\r\n"
                               "71   Strom L3(A) ""\r\n"
                               "72   Spannung L3(V)""\r\n"
			      );


		break;
		}
	cnt++;
	}
	else
		break;
   }
/*
   * Create a datagram socket on which to receive.
   */
  sd = socket(AF_INET, SOCK_DGRAM, 0);
  if (sd < 0) {
    perror("opening datagram socket");
    exit(1);
  }
 
  /*
   * Enable SO_REUSEADDR to allow multiple instances of this
   * application to receive copies of the multicast datagrams.
   */
  {
    int reuse=1;
 
    if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR,
                   (char *)&reuse, sizeof(reuse)) < 0) {
      perror("setting SO_REUSEADDR");
      close(sd);
      exit(1);
    }
  }
 
  /*
   * Bind to the proper port number with the IP address
   * specified as INADDR_ANY.
   */

  memset((char *) &localSock, 0, sizeof(localSock));
  localSock.sin_family = AF_INET;
  localSock.sin_port = htons(9522);;
  localSock.sin_addr.s_addr  = INADDR_ANY;
 
  if (bind(sd, (struct sockaddr*)&localSock, sizeof(localSock))) {
    perror("binding datagram socket");
    close(sd);
    exit(1);
  }
 
 
  /*
   * Join the multicast group on all  adresses
   * Note that this IP_ADD_MEMBERSHIP option must be
   * called for each local interface over which the multicast
   * datagrams are to be received.
   */
  group.imr_multiaddr.s_addr = inet_addr("239.12.255.254");
  group.imr_interface.s_addr = htonl(INADDR_ANY);
  if (setsockopt(sd, IPPROTO_IP, IP_ADD_MEMBERSHIP,
                 (char *)&group, sizeof(group)) < 0) {
    perror("adding multicast group");
    close(sd);
    exit(1);
  }
 

  /*
   * Read from the socket.
   */
  datalen = sizeof(emeter_data);


   if (read(sd, &emeter_data, datalen) < 0)
   	perror("reading datagram message");
   else
   {
	if(ShowTimestamp)
	{
		printf("%u; ",GETDW(emeter_data.ticker)/1000U);
	}
	if(ShowSerial)
	{
		printf("%05u%010u; ",GETW(emeter_data.susy), GETDW(emeter_data.serno));
	}
	while(cnt < argc)
	{
	  idx = atoi(argv[cnt++]);
	  if(cnt < argc)
		  typ = atoi(argv[cnt++]);
	  else
		  typ = 4;	// default current


	  if(ShowInfos) printf(" idx=%d; typ= %d; ",idx, typ);
	  (void )handle_emeter(&emeter_data, typ, idx);
	  if(cnt < argc)
		printf("; ");
        }
	printf("\r\n");
   }
  return 0;
}

